MObject->Fields (
  voluntary_carry => {default => 0},
  display_desc => {default => "<holder.vis?<self.vis?<holder> display<holder.is!s> <holder.genderp> <self.name>.>>"},
  offers => {default => [], nostore => 1},
);

MObject->Commands (
look => {
  basic => 1,
  requires => [],
  code => sub {
my ($self, $args) = @_;
  return unless $self->uses_output;
MModules->loaded('body_pos') and $self->bp_assert('look', 'look');
if ($args and $args !~ /^(a?round|a?bout|room|BRIEF)$/i) {
  $args =~ s/^(at?|in?)\s+//;
  my $lookin = $1 ? $1 =~ /i/ : 0;
  #$self->send("DEBUG: before object_find");
  my $obj = $self->object_find($args, extra_descs => 1);
  #$self->send("DEBUG: after object_find");
  if (not ref $obj) {
    # it's an extra desc
    $self->send($obj);
    return 1;
  }
  $self->nact('<self!<self> looks at <obj>.>', obj => $obj)
    unless $obj == $self or $obj->container == $self;
    
  my $buf = $lookin ? '' : $self->desc_gen($obj->ldesc, self => $obj) . "\n";

  if ($obj->cnt_interior or $obj->cnt_slot_nomax) {
    $buf .= "&:c;" .
      ($obj == $self ? 'You are carrying'
                     : ucfirst($obj->enter_prep . ' ' . $obj->nphr)) . ":&:n;\n";
    my $had = 0;
    foreach (@{$obj->contents}) {
      next if !$self->can_see($_);
      $had++;
      $buf .= (
        '&:fg;  '
        . $_->nphr
        . '&:n'
      #FIXME  . ($_->is_slot ? ' (' . $_->is_slot . ')': '')
        . "\n"
      );
    }
    $had or $buf .= "  Nothing.\n";
  }
  $self->send_page($buf);
} else {
  my $inside = $self->container or do {
    $self->send("You see nothing at all.");
    return;
  };
  
  $inside = $inside->container while $inside->glance_contents and $inside->container;
  
  if (!$inside or !$self->can_see($inside)) {
    $self->send("You see nothing at all.");
    return;
  }
  
  if ($args =~ /^(a?round|a?bout)$/i) {
    my $lroundsub = sub {
      my ($room) = @_;
      my $buf = '';
      my @objects;
      foreach (grep $_->name ne $self->name, @{$room->contents}) {
        push @objects, (
          ($_->voluntary_carry ? '&:fy;' : '&:fg;')
          . $_->name
          . "&:n\n"
        );
      }
      my (%seen, @obj_grp);
      for (my $i = 0; $i < @objects; $i++) {
        $seen{$objects[$i]}++ and next;
        push @obj_grp, $objects[$i];
      }
      foreach (@obj_grp) {
        $buf .= "   " . ($seen{$_} > 1 ? sprintf('[%2d] ', $seen{$_}) : '') . $_;
      }
      return $buf;
    };
    # FIXME: look around needs checks for max vision distance, light level.
    my $buf = "You look around and see:\n";
    $buf .= "here:\n" . $lroundsub->($inside);
    foreach my $dir (qw(north northeast east southeast south southwest west northwest up down)) {
      my $dist = 0; my $nroom = $inside; my ($exit, %seen);

      while ($exit = $nroom->exits->{$dir} 
             and $nroom = MObjectDB->get($exit->{to})
             and !$exit->{minor}
             and !$seen{$nroom}
      ) {
        $dist++;
        if ($exit->{closed}) {
          $buf .= $dist." room".($dist==1 ? ' ' : 's ').$dir
            . ($exit->{door} ? ": " . $exit->{door}: '') . "\n";
        } else {
          my $stuff = $lroundsub->($nroom);
          $buf .= $dist." room".($dist==1 ? ' ' : 's ').$dir
            . ($exit->{door} ? ", through " . $exit->{door}: '') . ":\n$stuff"
            if $stuff;
        }
        $seen{$nroom}++;
      }
    }
    $self->send_page($buf);
  } else {
    my ($left, $right) = ('', '');
    my $center = " &:c;" . ucfirst((!$inside->container ? '' : $inside->enter_prep . " ") . $inside->nphr) . "&:b; ";
    if ($self->priv_watcher) {
      my $proto = $inside->prototype;
      $left = defined $proto ? "[P: $proto] " : '';
      my $name = MIndex->find_reverse($inside);
      $right = $name ? " [N: $name]" : '';
    }

    my $con = $self->connection;
    my $brief = ($args eq 'BRIEF' and $con and $con->pref('brief'));
 
    my $wid = ($con ? $con->scr_width : 80);
    my $header = '-' x $wid;
    substr($header, 0, length($left)) = $left if $left;
    substr($header, -length($right)) = $right if $right;
    substr($header, ($wid - length($center) + 8) / 2, length($center) - 8) = $center;

    my $image = '';
    if (MModules->loaded('roomexits') and !$brief) {
      my %exlist = map {$_, 1} keys %{$inside->exits};
      $image = ($exlist{northwest} ? ' \\': '  ') .
               ($exlist{north}     ? '|'  : ' ' ) .
               ($exlist{northeast} ? '/ ' : '  ') . " \n".
               ($exlist{west}      ? '--' : '  ') .
               (
                 $exlist{up} ? ($exlist{down} ? '*' : '>')
                             : ($exlist{down} ? '<' : '+')
               ) .
               ($exlist{east}      ? '--' : '  ') . " \n".
               ($exlist{southwest} ? ' /' : '  ') .
               ($exlist{south}     ? '|'  : ' ' ) .
               ($exlist{southeast} ? '\\ ': '  ') . " \n";
    }

    my $idesc = $brief ? ''
      : "   " . $self->desc_gen($inside->idesc, 'self' => $inside) . "\n";
    $idesc =~ s/\n{2,}\Z/\n/g;
    
    my $buf = "\n&:b;$header&:n;\n" . ($con ? $con->format_wrap($idesc, picture => $image) : $idesc);
    $buf .= join "\n", call_hooks('look_inside_extra_info', $inside, $self);

    my @objects;
    foreach (grep $_->name ne $self->name, @{$inside->contents}) {
      push @objects, [$_, $_->desc_in_room($self)] if $self->can_see($_);
    }
    my (%seen, @obj_grp);
    for (my $i = 0; $i < @objects; $i++) {
      $seen{$objects[$i][1]}++ and next;
      push @obj_grp, $objects[$i];
    }
    foreach (@obj_grp) {
      $buf .= ($seen{$_->[1]} > 1 ? $_->[0]->desc_in_room($self, $seen{$_->[1]}) : $_->[1]) . "\n";
    }
    $self->send_page($buf);
  }
}
  },
},
inventory => {code => sub {$_[0]->do('look in self');}},
get => {code => 'GenericVerb', findopt => {no_self_contents => 1}},
drop => {code => 'GenericVerb', findopt => {no_outside => 1}},
give => {code => 'GenericVerb', findopt => {no_outside => 1}},
put => {code => 'GenericVerb'},
enter => {code => 'GenericVerb'},
leave => {
  code => sub {
    my ($self, $args) = @_;
    
    my $hasbp = MModules->loaded('body_pos');
    $hasbp and $self->bp_assert('reach_object') and $self->bp_assert('move');

    my $pcon;
    unless ($pcon = $self->container) {
      $self->send("You aren't inside anything! How can you leave??");
      return;
    }

    my $obj = $pcon->container;
    if (!$obj) {
      $self->send("There's nothing to leave to.");
      return;
    }
    if (!$obj->can_contain($self)) {
      $self->send("There's no room for you to get out of " . $pcon->name . ".");
      return;
    }

    $self->nact('<self.name> leave<self.is!s> <pcon.name>.', self => $self, pcon => $pcon);
    $self->move_into($obj);
    #$self->nact('<self> gets out of @{[$pcon->name]}.");
    #$self->pause_commands(2);
  },
},
# FIXME: implement use/remove
display => {code => 'GenericVerb'},
# FIXME: implement accept/deny
);

MObject->VerbDefs (
get => sub {
  my ($self, $caller, %objects) = @_;
  
  MModules->loaded('body_pos') and $caller->bp_assert('reach_object');
  if ($self->container->voluntary_carry) {
    $caller->send("You can't do that.");
    return;
  }
  
  $self->nact('<a> get<a!s> <self>.', a => $caller);
  $self->move_into($caller);
},
drop => sub {
  #print "DEBUG: entering drop handler\n";
  my ($self, $caller, %objects) = @_;
  MModules->loaded('body_pos') and $caller->bp_assert('reach_object');

  $self->nact('<a> drop<a!s> <self>.', a => $caller);
  $self->move_into($caller->container);
  #print "DEBUG: leaving drop handler\n";
},
);

MObject->CommandAliases(
  look => [qw(examine read)],
  get => [qw(take)],
  'use' => [qw(wear wield hold grab)],
  remove => [qw(unwear unwield)],
  leave => [qw(out exit)],
  display => [qw(show brandish)],
);

MObject->Methods(
desc_in_room => sub {
  my ($self, $viewer, $plural) = @_;
  
  # FIXME: this ought to be a local subroutine
  
  my $name_with_mods = sub {
    my ($obj) = @_;
    my $c;
    my $flstr = (''
      . ( ($obj->connection)                                            ? ' (connected)' : '')
      . ( $obj->invisible                                               ? ' (invisible)' : '')
      . ( ($c = $obj->connection and $c->isa('MConnection::Capturing')) ? ' (logging)'   : '')
    );
    return $obj->nphr($plural) . $flstr;
  };

  my $pre = $self->voluntary_carry ? '&:fy;' : '&:fg;';
  my $post = '&:n;';

  my $hasbp = MModules->loaded('body_pos') && $self->has_body_pos;
  if (@{$self->contents} and $self->glance_contents) {
    if (@{$self->contents} > 1) {
      return $pre . ucfirst($name_with_mods->($self)) . ' ' . ($plural?'are':'is') . ' here, with ' . do {
        my $l = join(', ', map {!$viewer->can_see($_) ? () : $_ == $viewer ? 'you' : $name_with_mods->($_)} @{$self->contents});
        $l =~ s/, ([^,]+)$/ and $1/;
        $l;
      } . ' ' . $self->enter_prep . ' ' . $GENDER_NOM{$self->gender} . ".$post";
    } else {
      my $thing = $self->contents->[0];
      return ($thing->voluntary_carry ? '&:fy;' : '&:fg;') . ($thing == $viewer ? "You are" : $name_with_mods->($thing) . ' ' . ($plural?'are':'is'))
        . (MModules->loaded('body_pos') && $thing->has_body_pos ? ' '.$thing->bp_desc : '')
        . " " . $self->enter_prep . " " . $name_with_mods->($self)
        . ($thing->doing ? ", " . $viewer->desc_gen($thing->doing) : '') . ".$post";
    }
  }
  return
    $pre . (ucfirst $name_with_mods->($self) . ' ' . ($plural?'are':'is')
    . ($hasbp ? ' '.$self->bp_desc : '')
    . " here" . ($self->doing ? ", " . $viewer->desc_gen($self->doing) : '') . ".$post");
},

can_contain => sub {
  my ($self, $other) = @_;
  return 1; # FIXME FIXME
  my $total = $other->total_volume;
  my $noslot = $self->cnt_slot_nomax;
  foreach (@{$self->contents}) {
    $total += $_->total_volume unless $noslot and $_->is_slot;
  }
  return ($total <= $self->cnt_interior);
},

);
